/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.quadsearch;

import com.terraforged.mod.Log;
import com.terraforged.mod.util.quadsearch.Search;
import com.terraforged.mod.util.quadsearch.SearchContext;
import com.terraforged.noise.util.Vec2i;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;

public class QuadSearch {
    private static final Vec2i[] QUADS = new Vec2i[]{new Vec2i(1, 1), new Vec2i(1, -1), new Vec2i(-1, 1), new Vec2i(-1, -1)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T search(int x, int z, int radius, int stepSize, Search<T> search, SearchContext context) {
        T t;
        long start = System.nanoTime();
        try {
            t = QuadSearch.search(x, z, radius, stepSize, 0, 1, search, context.startTask());
        }
        catch (Throwable throwable) {
            long duration = System.nanoTime() - start;
            Log.debug("Search completed in {}ms", TimeUnit.NANOSECONDS.toMillis(duration));
            throw throwable;
        }
        long duration = System.nanoTime() - start;
        Log.debug("Search completed in {}ms", TimeUnit.NANOSECONDS.toMillis(duration));
        return t;
    }

    public static <T> T asyncSearch(int x, int z, int radius, int stepSize, Search<T> search, SearchContext context) {
        return QuadSearch.asyncSearch(x, z, radius, stepSize, Runtime.getRuntime().availableProcessors(), search, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T asyncSearch(int x, int z, int radius, int stepSize, int workers, Search<T> search, SearchContext context) {
        T t;
        if (workers <= 1) {
            return QuadSearch.search(x, z, radius, stepSize, search, context.startTask());
        }
        long start = System.nanoTime();
        try {
            ForkJoinTask[] tasks = new ForkJoinTask[workers];
            int i = 0;
            while (i < workers) {
                int workerId = i++;
                SearchContext taskContext = context.startTask();
                Callable<Object> task = () -> QuadSearch.search(x, z, radius, stepSize, workerId, workers, search, taskContext);
                tasks[workerId] = ForkJoinPool.commonPool().submit(task);
            }
            t = QuadSearch.waitOnResults(tasks, search, context);
        }
        catch (Throwable throwable) {
            long duration = System.nanoTime() - start;
            Log.debug("Async search completed in {}ms", TimeUnit.NANOSECONDS.toMillis(duration));
            throw throwable;
        }
        long duration = System.nanoTime() - start;
        Log.debug("Async search completed in {}ms", TimeUnit.NANOSECONDS.toMillis(duration));
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T search(int x, int z, int searchRadius, int stepSize, int worker, int workers, Search<T> search, SearchContext context) {
        try (Search<T> ignored1 = search;
             SearchContext ignored2 = context;){
            int taskCounter = 0;
            int radius = 0;
            while (radius <= searchRadius) {
                for (int r = 0; r <= radius && !context.isComplete(radius); ++r) {
                    int task2;
                    int task1;
                    T result;
                    if ((result = QuadSearch.searchQuads(x, z, r, radius, stepSize, worker, workers, task1 = taskCounter++, task2 = r == radius ? -1 : taskCounter++, search, context)) != null) {
                        context.submit(radius);
                        T t = result;
                        return t;
                    }
                    Throwable error = search.error();
                    if (error == null) continue;
                    context.submit(Integer.MIN_VALUE);
                    T t = null;
                    return t;
                }
                ++radius;
            }
            return null;
        }
    }

    private static <T> T searchQuads(int x, int z, int r, int radius, int spacing, int worker, int workers, int task1, int task2, Search<T> search, SearchContext context) {
        int rf = r * spacing;
        int radiusf = radius * spacing;
        Object result = null;
        for (Vec2i dir : QUADS) {
            int pz;
            int maxX;
            int maxZ;
            int px;
            if (context.isComplete(r)) break;
            int startX = x + Math.min(0, dir.x * spacing);
            int startZ = z + Math.min(0, dir.y * spacing);
            if (QuadSearch.isCurrentThreadsTask(task1, worker, workers) && search.test(px = startX + dir.x * rf, maxZ = startZ + dir.y * radiusf)) {
                task1 = -1;
                result = QuadSearch.getResult(result, search.result(), search);
            }
            if (QuadSearch.isCurrentThreadsTask(task2, worker, workers) && search.test(maxX = startX + dir.x * radiusf, pz = startZ + dir.y * rf)) {
                task2 = -1;
                result = QuadSearch.getResult(result, search.result(), search);
            }
            if (task1 == -1 && task2 == -1) break;
        }
        return result;
    }

    private static boolean isCurrentThreadsTask(int taskId, int workerId, int workerCount) {
        return taskId != -1 && (workerCount <= 1 || taskId % workerCount == workerId);
    }

    private static <T> T waitOnResults(ForkJoinTask<T>[] tasks, Search<T> search, SearchContext context) {
        Object result = null;
        while (context.hasTasks() && !context.hasTimedOut()) {
            for (ForkJoinTask<T> task : tasks) {
                if (!task.isDone()) continue;
                result = QuadSearch.getResult(result, task.join(), search);
            }
        }
        if (search.error() != null) {
            return null;
        }
        return result;
    }

    private static <T> T getResult(T current, T value, Comparator<T> comparator) {
        if (current == null) {
            return value;
        }
        if (value == null) {
            return current;
        }
        if (comparator.compare(value, current) <= 0) {
            return value;
        }
        return current;
    }
}

